<?php
session_start();

// Força o navegador a sempre carregar esta página (sem armazenar o histórico de navegação)
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: 0");

// Verifica se o usuário está autenticado
if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
    header('Location: login.php');
    exit;
}

?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Página Principal</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #1d222e;
            color: white;
            text-align: center;
        }
        .container {
            max-width: 500px;
            margin: 0 auto;
            padding: 20px;
            background-color: #252b3b;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(255, 255, 255, 0.2);
        }
        h2 {
            margin-bottom: 20px;
        }
        .button {
            padding: 15px 30px;
            margin: 15px 0;
            font-size: 16px;
            text-decoration: none;
            color: white;
            background-color: #007bff;
            border-radius: 5px;
            display: inline-block;
        }
        .button:hover {
            background-color: #0056b3;
        }
        .home-button {
            padding: 10px 20px;
            background-color: #28a745;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-bottom: 20px;
            display: inline-block;
        }
        .home-button:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>

<!-- Botão Home -->
<a href="index.php" class="home-button">Home</a>

<div class="container">
    <h2>Escolha uma opção</h2>

    <!-- Botões de Redirecionamento -->
    <a href="https://painel.ibo.cineclubtv.top/login.php" class="button">Ir para o Painel IBO</a>
    <a href="https://painel.ibo.cineclubtv.top/alldns.php" class="button">Ir para o Editor de DNS</a>
</div>

</body>
</html>
