<?php
session_start(); // Inicia a sessão

// Credenciais de login
$valid_username = "admin";
$valid_password = "Ander,061290.";

// Verifica se o usuário está autenticado
if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
    // Se não estiver autenticado, exibe o formulário de login
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Verifica se o nome de usuário e senha estão corretos
        if ($_POST['username'] === $valid_username && $_POST['password'] === $valid_password) {
            // Autentica o usuário e redireciona
            $_SESSION['authenticated'] = true;
            header('Location: ' . $_SERVER['PHP_SELF']);
            exit;
        } else {
            $login_error = "Usuário ou senha inválidos!";
        }
    }
    // Se o usuário não estiver autenticado, exibe a tela de login
    echo '<!DOCTYPE html>
    <html lang="pt">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Login</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                background-color: #1d222e;
                color: white;
                text-align: center;
            }
            .container {
                max-width: 400px;
                margin: 0 auto;
                padding: 20px;
                background-color: #252b3b;
                border-radius: 10px;
                box-shadow: 0 0 10px rgba(255, 255, 255, 0.2);
            }
            input, button {
                padding: 10px;
                margin: 5px;
                width: 90%; /* Ajuste o campo para 90% de largura */
            }
            .error {
                color: red;
                margin-bottom: 15px;
            }
            label {
                display: block;
                margin-bottom: 5px;
                text-align: left;
            }
            .show-password {
                font-size: 14px;
                margin-top: 5px;
                text-align: left;
                display: flex;
                justify-content: start;
                align-items: center;
            }
            .show-password input[type="checkbox"] {
                width: auto; /* Remove o efeito de largura no checkbox */
            }
            .home-button {
                padding: 10px 20px;
                background-color: #28a745; /* Cor verde */
                color: white;
                text-decoration: none;
                border-radius: 5px;
                margin-bottom: 20px;
                display: inline-block;
                font-size: 18px; /* Aumenta o tamanho da fonte */
            }
            .home-button:hover {
                background-color: #218838; /* Cor verde mais escura ao passar o mouse */
            }
        </style>
    </head>
    <body>

    <a href="redirecionamento.php" class="home-button">Voltar para redirecionamento</a>

    <div class="container">
        <h2>Login</h2>';
    if (isset($login_error)) {
        echo '<p class="error">' . $login_error . '</p>';
    }
    echo '
        <form method="POST">
            <label for="username">Usuário:</label><br>
            <input type="text" name="username" id="username" required><br>

            <label for="password">Senha:</label><br>
            <input type="password" name="password" id="password" required><br>

            <div class="show-password">
                <label for="show_password">
                    <input type="checkbox" id="show_password" onclick="togglePassword()"> Mostrar Senha
                </label>
            </div>

            <button type="submit">Entrar</button>
        </form>
    </div>

    <script>
        function togglePassword() {
            var passwordField = document.getElementById("password");
            if (document.getElementById("show_password").checked) {
                passwordField.type = "text";
            } else {
                passwordField.type = "password";
            }
        }
    </script>

    </body>
    </html>';
    exit;
}

// A partir daqui, o código é executado apenas se o usuário estiver autenticado

// Logout
if (isset($_GET['logout'])) {
    $_SESSION['authenticated'] = false; // Define a variável de autenticação como falsa
    header('Location: redirecionamento.php'); // Redireciona para a página de redirecionamento
    exit;
}

// Conectar ao banco de dados
$db = new SQLite3('./a/.eggziedb.db');

// Verifica se a tabela 'ibo' existe
$checkTable = $db->querySingle("SELECT name FROM sqlite_master WHERE type='table' AND name='ibo'");
if (!$checkTable) {
    die("Erro: A tabela 'ibo' não existe no banco de dados.");
}

// Buscar todas as URLs agrupadas e contar ocorrências
$query = $db->query('SELECT url, COUNT(*) as count FROM ibo GROUP BY url ORDER BY count DESC');

$urls = [];
while ($row = $query->fetchArray(SQLITE3_ASSOC)) {
    $urls[] = $row;
}

// Processa a atualização em massa se o formulário for enviado
if (isset($_POST['submit']) && !empty($_POST['old_url']) && !empty($_POST['new_url'])) {
    $old_url = $_POST['old_url'];
    $new_url = $_POST['new_url'];

    // Atualizar todas as ocorrências da URL antiga para a nova
    $updateQuery = $db->exec("UPDATE ibo SET url = '$new_url' WHERE url = '$old_url'");

    if ($updateQuery) {
        echo "<p style='color: green;'>URLs atualizadas com sucesso!</p>";
    } else {
        echo "<p style='color: red;'>Erro ao atualizar URLs.</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de URLs</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #1d222e;
            color: white;
            text-align: center;
        }
        .container {
            max-width: 500px;
            margin: 0 auto;
            padding: 20px;
            background-color: #252b3b;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(255, 255, 255, 0.2);
        }
        input[type="text"], input[type="password"], select {
            padding: 10px;
            margin: 5px;
            width: 90%; /* Ajuste a largura dos campos */
        }
        input[type="submit"], button {
            padding: 10px;
            margin: 5px;
            width: auto; /* Largura do botão ajustada */
        }
        #search {
            width: 90%;  /* Ajustado */
            padding: 10px;
            margin-bottom: 10px;
            border-radius: 5px;
            border: none;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        th, td {
            padding: 8px;
            border-bottom: 1px solid #555;
            text-align: left;
        }
        th {
            background-color: #333;
        }
        .home-button {
            padding: 10px 20px;
            background-color: #28a745;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-bottom: 20px;
            display: inline-block;
        }
        .home-button:hover {
            background-color: #218838;
        }
        .logout-button {
            padding: 10px 20px;
            background-color: #dc3545;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-bottom: 20px;
            display: inline-block;
        }
        .logout-button:hover {
            background-color: #c82333;
        }
        .show-password {
            font-size: 14px;
            margin-top: 5px;
            text-align: left;
            display: flex;
            justify-content: start;
            align-items: center;
        }
        .show-password input[type="checkbox"] {
            width: auto; /* Remove a largura no checkbox */
        }
    </style>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            // Inicializa o select2 para permitir a pesquisa na lista suspensa
            $('#urlSelect').select2({
                placeholder: "Selecione uma URL",
                allowClear: true,
                width: '100%'
            });
        });
        
        function searchURL() {
            let input = document.getElementById("search").value.toLowerCase();
            let rows = document.querySelectorAll("#urlTable tbody tr");

            rows.forEach(row => {
                let url = row.querySelector("td:first-child").textContent.toLowerCase();
                row.style.display = url.includes(input) ? "" : "none";
            });
        }
    </script>
</head>
<body>

<!-- Botão Home -->
<a href="redirecionamento.php" class="home-button">Voltar para o Redirecionamento</a>

<!-- Botão Sair (Logout) -->
<a href="?logout=true" class="logout-button">Sair</a>

<div class="container">
    <h2>Lista de URLs</h2>

    <!-- Campo de pesquisa -->
    <input type="text" id="search" onkeyup="searchURL()" placeholder="Pesquisar URL...">

    <table id="urlTable">
        <thead>
            <tr>
                <th>URL</th>
                <th>Quantidade</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($urls as $row): ?>
                <tr>
                    <td><?php echo htmlspecialchars($row['url']); ?></td>
                    <td><?php echo $row['count']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <h3>Alterar URL</h3>
    <form method="post">
        <!-- Lista suspensa com pesquisa -->
        <label for="urlSelect">Selecione a URL Antiga:</label><br>
        <select id="urlSelect" name="old_url" required>
            <option value="">Selecione uma URL</option>
            <?php foreach ($urls as $row): ?>
                <option value="<?php echo htmlspecialchars($row['url']); ?>"><?php echo htmlspecialchars($row['url']); ?></option>
            <?php endforeach; ?>
        </select><br>

        <label for="new_url">Nova URL:</label><br>
        <input type="text" name="new_url" id="new_url" required><br>

        <button type="submit" name="submit">Atualizar</button>
    </form>
</div>

</body>
</html>