<?php


 /**
  *
  */
 class API extends Conn
 {


      function __construct()
      {
        $this->conn = new Conn;
        $this->pdo  = $this->conn->pdo();
      }


      public function list_chaves(){

        $query = $this->pdo->query("SELECT * FROM `chaves` ");
        $fetch = $query->fetchAll(PDO::FETCH_OBJ);

        if(count($fetch)>0){

          $query = $this->pdo->query("SELECT * FROM `chaves`");
          return $query;

        }else {
          return false;
        }

      }


      public function crypto_rand_secure($min, $max){
            $range = $max - $min;
            if ($range < 1) return $min; // not so random...
            $log = ceil(log($range, 2));
            $bytes = (int) ($log / 8) + 1; // length in bytes
            $bits = (int) $log + 1; // length in bits
            $filter = (int) (1 << $bits) - 1; // set all lower bits to 1
            do {
                $rnd = hexdec(bin2hex(openssl_random_pseudo_bytes($bytes)));
                $rnd = $rnd & $filter; // discard irrelevant bits
            } while ($rnd > $range);
            return $min + $rnd;
        }

    public function getToken($length){
            $token = "";
            $codeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            $codeAlphabet.= "abcdefghijklmnopqrstuvwxyz";
            $codeAlphabet.= "0123456789";
            $max = strlen($codeAlphabet); // edited

            for ($i=0; $i < $length; $i++) {
                $token .= $codeAlphabet[self::crypto_rand_secure(0, $max-1)];
            }

            return $token;
        }

    public function create_chave($user)  {

      $chave = self::getToken(20);

      $query = $this->pdo->prepare("INSERT INTO `chaves`  (chave,id_user,painel,username,password,vencimento,situ) VALUES (:chave,:id_user,:painel,:username,:password,:vencimento,:situ)");
      $query->bindValue(':chave',$chave);
      $query->bindValue(':id_user',$dados->id_user);
      $query->bindValue(':username',$dados->username);
      $query->bindValue(':password',$dados->password);
      $query->bindValue(':vencimento','00/00/0000');
      $query->bindValue(':situ',0);

      if($query->execute()){
        return true;
      }else{
        return false;
      }


    }




    public function vencimento($vencimento){

      $ven_user = "";

      // verificar data do vencimento
      $explodeData_user  = explode('/',$vencimento);
      $explodeData2_user = explode('/',date('d/m/Y'));
      $dataVen_user      = $explodeData_user[2].$explodeData_user[1].$explodeData_user[0];
      $dataHoje_user     = $explodeData2_user[2].$explodeData2_user[1].$explodeData2_user[0];

      if($dataVen_user == $dataHoje_user){
          $ven_user = "ven_today";
      }else if($dataHoje_user > $dataVen_user){

         if($user->vencimento == "00/00/0000"){
           $ven_user = "vencido";
         }else{
           $ven_user = "vencido";
         }

      }

      return $ven_user;

    }


    public function verific_email($email){

      $q = $this->pdo->prepare("SELECT * FROM `usuario` WHERE email= :email");
      $q->bindValue(':email', $email);
      $q->execute();
      $fetch = $q->fetchAll(PDO::FETCH_OBJ);
      if(count($fetch)>0){
        return true;
      }else{
        return false;
      }

    }



    public function verific_access($chave){

      $q = $this->pdo->prepare("SELECT * FROM `chaves` WHERE chave= :chave AND situ= :situ");
      $q->bindValue(':chave', $chave);
      $q->bindValue(':situ', 1);
      $q->execute();
      $fetch = $q->fetchAll(PDO::FETCH_OBJ);
      if(count($fetch)>0){
        return true;
      }else{
        return false;
      }

    }

    public function dados($id){

      $query = $this->pdo->query("SELECT * FROM `usuario` WHERE id='$id' ");
      $fetch = $query->fetchAll(PDO::FETCH_OBJ);
      if(count($fetch)>0){

        $query = $this->pdo->query("SELECT * FROM `usuario` WHERE id='$id' ");
        $fetch = $query->fetch(PDO::FETCH_OBJ);
        return $fetch;

      }else{
        return false;
      }


    }

    public function dados_chave($chave){

      $query = $this->pdo->query("SELECT * FROM `chaves` WHERE chave='$chave' ");
      $fetch = $query->fetchAll(PDO::FETCH_OBJ);
      if(count($fetch)>0){

        $query = $this->pdo->query("SELECT * FROM `chaves` WHERE chave='$chave' ");
        $fetch = $query->fetch(PDO::FETCH_OBJ);
        return $fetch;

      }else{
        return false;
      }


    }

    public function update_vencimento($vencimento,$chave){

          $query = $this->pdo->prepare("UPDATE `chaves` SET vencimento= :vencimento WHERE chave= :chave");
          $query->bindValue(':vencimento',$vencimento);
          $query->bindValue(':chave',$chave);

          if($query->execute()){
            return true;
          }else{
            return false;
          }


    }


 }




?>
