(function($,win){"use strict";var requestFrame=function(){var raf=win.requestAnimationFrame||win.mozRequestAnimationFrame||win.webkitRequestAnimationFrame||function(fn){return win.setTimeout(fn,20)};return function(fn){return raf(fn)}}();var style=(win.document.body||win.document.documentElement).style;var prop="transition";var supportsTransition=typeof style[prop]=="string";var events={created:"sticky-created",update:"sticky-update",top:"sticky-hit-top",bottom:"sticky-hit-bottom",frozen:"sticky-frozen",unfrozen:"sticky-unfrozen"};var Sticky=function(elm,par,options){this.element=elm;this.parent=par;this._frozen=false;this._stopped=true;this.options=$.extend({useTransition:true,animate:true,animTime:200,animDelay:300},options);var offset=parseInt(options.offset,10);this.options.offset=isNaN(offset)?0:offset;this.init()};Sticky.prototype.init=function(){var transition="";if(this.options.useTransition&&supportsTransition){transition="top "+this.options.animTime+"ms ease-in-out";this.options.animate=false}this.parent.css({position:"relative"});this.element.addClass("sticky-scroll").css({transition:transition,position:"relative"});this.element.trigger(events.created);this.update()};Sticky.prototype.update=function(){this.setBoundaries(0);this.moveIt();this.element.trigger(events.update)};Sticky.prototype.moveIt=function(){var scrollTop=(win.document.documentElement.scrollTop||win.document.body.scrollTop)+this.options.offset;var height=this.element.outerHeight(true);var realStop=this._stop-height;if(this._parentHeight-this._offset>height&&!this._frozen){if(scrollTop>=this._start&&scrollTop<=realStop){this.updateOffset(scrollTop-this._start);this._stopped=false}else{if(scrollTop<this._start){this.updateOffset(0);if(!this._stopped){this.element.trigger(events.top)}this._stopped=true}else if(scrollTop>realStop){this.updateOffset(this._parentHeight-height-this._offset);if(!this._stopped){this.element.trigger(events.bottom)}this._stopped=true}}}};Sticky.prototype.setBoundaries=function(offset){this._offset=typeof offset==="undefined"?this.element.position().top:offset;this._start=this.parent.offset().top+this._offset;this._parentHeight=this.parent[0].offsetHeight;this._stop=this._start+this._parentHeight-this._offset};Sticky.prototype.setOffset=function(newOffset){newOffset=parseInt(newOffset,10);if(!isNaN(newOffset)){this.options.offset=newOffset;this.moveIt()}};Sticky.prototype.updateOffset=function(yOffset){if(this._lastPosition!==yOffset){if(this.options.animate){this.element.stop(true,false).delay(this.options.animDelay).animate({top:yOffset},this.animTime)}else{this.element.css("top",yOffset)}this._lastPosition=yOffset}};Sticky.prototype.toggleFreeze=function(){this._frozen=!this._frozen;this.element.stop(true,false);if(!this._frozen){this.element.trigger(events.unfrozen);this.moveIt()}else{this.element.trigger(events.frozen)}};$.fn.sticky=function(parentName,options){var method=parentName;var ret=false;this.each(function(){var self=$(this);var instance=self.data("stickyInstance");if(instance&&(options||method)){if(typeof options==="object"){ret=$.extend(instance.options,options)}else if(options==="options"){ret=instance.options}else if(typeof instance[method]==="function"){ret=instance[method].call(instance,options)}else{console.error("Sticky Element has no option/method named "+method)}}else{var parent=null;if(parent){parent=self.parent().closest(parent)}else{parent=self.parent()}instance=new Sticky(self,parent,options||{});self.data("stickyInstance",instance);$.fn.sticky._instances.push(instance)}});return ret||this};var updateAll=function(){var len=$.fn.sticky._instances.length;for(var i=0;i<len;i++){$.fn.sticky._instances[i].update()}};$.fn.sticky._instances=[];$.fn.sticky.updateAll=updateAll;$(win).on({resize:function(){updateAll()},scroll:function(){var len=$.fn.sticky._instances.length;for(var i=0;i<len;i++){var element=$.fn.sticky._instances[i];if(!element._frozen){element.moveIt()}}}});$(win.document).on({ready:function(){win.setInterval(function(){requestFrame(function(){var len=$.fn.sticky._instances.length;for(var i=0;i<len;i++){var element=$.fn.sticky._instances[i];if(element._parentHeight!==element.parent[0].offsetHeight){element.update()}}})},1e3)}})})(jQuery,window);